﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataService.Models;
using PpmsDataService.ModelsEnumTypes;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class ProviderNetworkMap
    {
        public static async Task<IQueryable<ProviderNetwork>> MapProviderNetworks(List<ppms_vaprovidernetwork> ppmsProviderNetworks, string mapRelatedType, PpmsContext context)
        {
            var providerNetworks = new List<ProviderNetwork> { };
            foreach (var ppmsProviderNetwork in ppmsProviderNetworks)
            {
                var network = NetworkIds.GetNetwork(ppmsProviderNetwork.Id);

                var providerNetwork = new ProviderNetwork
                {
                   ProviderNetworkName = ppmsProviderNetwork.ppms_name,
                   ShortHand = ppmsProviderNetwork.ppms_shorthand,
                   NetworkId = network.Number
                };


                if (ppmsProviderNetwork.ppms_operatingorganization != null)
                {
                    providerNetwork.OperatingOrganizationName = ppmsProviderNetwork.ppms_operatingorganization.Name;
                }

                //Network Type Switch
                if (ppmsProviderNetwork.ppms_networktype != null)
                    switch (ppmsProviderNetwork.ppms_networktype.Value)
                    {
                        case (int)ppms_vaprovidernetwork_ppms_networktype.ComplementaryServices:
                            providerNetwork.NetworkType = NetworkType.ComplementaryServices;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_networktype.Core:
                            providerNetwork.NetworkType = NetworkType.Core;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_networktype.External:
                            providerNetwork.NetworkType = NetworkType.External;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_networktype.HighPerforming:
                            providerNetwork.NetworkType = NetworkType.HighPerforming;
                            break;
                    }

                //Network Region Switch
                if (ppmsProviderNetwork.ppms_NetworkRegion != null)
                    switch (ppmsProviderNetwork.ppms_NetworkRegion.Value)
                    {
                        case (int)ppms_vaprovidernetwork_ppms_NetworkRegion.Region1:
                            providerNetwork.NetworkRegion = NetworkRegion.Region1;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_NetworkRegion.Region2:
                            providerNetwork.NetworkRegion = NetworkRegion.Region2;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_NetworkRegion.Region3:
                            providerNetwork.NetworkRegion = NetworkRegion.Region3;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_NetworkRegion.Region4:
                            providerNetwork.NetworkRegion = NetworkRegion.Region4;
                            break;
                    }

                //Extract the Related type from queryType string
                if (mapRelatedType.Contains("?$expand=OperatingOrganization"))
                    mapRelatedType = "OperatingOrganization";
                if (mapRelatedType.Contains("?$expand=VaProviderRelationships"))
                    mapRelatedType = "VaProviderRelationships";

                //Map Related Types
                switch (mapRelatedType)
                {
                    case "OperatingOrganization":
                        //Lookup and Map the related Operating Org
                        var OperatingOrg =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderNetwork.ppms_operatingorganization.Id);
                        var operatingOrgList = new List<Account> { OperatingOrg };
                        providerNetwork.OperatingOrganization =
                            await ProviderMap.MapProviders(operatingOrgList, "None", context);
                        break;
                    case "VaProviderRelationships":
                        //Lookup and Map the Care Sites
                        var ppmsVaProviderRelationships =
                            context.ppms_vaproviderrelationshipSet.Where(i => i.ppms_ProviderNetwork.Id == ppmsProviderNetwork.Id);
                        var ppmsVaProviderRelationshipsList = ppmsVaProviderRelationships.ToList();
                        providerNetwork.VaProviderRelationships =
                            await VaProviderRelationshipMap.MapVaProviderRelationships(ppmsVaProviderRelationshipsList, "None", context);
                        break;
                    default:
                        break;
                }

                providerNetworks.Add(providerNetwork);
            }
            return providerNetworks.AsQueryable();
        }      
    }
}